/*
 * Copyright 2012 Thomas Broyer <t.broyer@ltgt.net>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.calpano.common.client.history;

import org.xydra.annotations.LicenseApache;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryHandler.Historian;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.Window;

/**
 * Currently unused.
 *
 * IMPL: Still using GWTs old event types, as the mGWT stuff requires it
 *
 * An {@link Historian} using HTML5's {@code pushState} and {@code onpopstate}.
 * <p>
 * This code has only been tested in Firefox and Chrome, with
 * {@link com.google.gwt.place.shared.PlaceHistoryHandler#handleCurrentHistory()}
 * called from the {@link com.google.gwt.core.client.EntryPoint EntryPoint}
 * (i.e. I don't know how it would work otherwise, wrt. Chrome firing an initial
 * {@code popstate} event).
 *
 * See https://developer.mozilla.org/en/DOM/Manipulating_the_browser_history
 *
 * See
 * https://github.com/balupton/history.js/wiki/The-State-of-the-HTML5-History
 * -API
 */
@LicenseApache(copyright = "Copyright 2012 Thomas Broyer <t.broyer@ltgt.net>")
public class Html5Historian implements Historian, PlaceHistoryMapper,
// allows the use of ValueChangeEvent.fire()
		HasValueChangeHandlers<String> {

	private static final Logger log = LoggerFactory.getLogger(Html5Historian.class);

	private final SimpleEventBus handlers = new SimpleEventBus();

	public Html5Historian() {
		initEvent();
		log.debug("Initialized.");
	}

	@Override
	public HandlerRegistration addValueChangeHandler(final ValueChangeHandler<String> valueChangeHandler) {
		return this.handlers.addHandler(ValueChangeEvent.getType(), valueChangeHandler);
	}

	private native String decodeFragment(String encodedFragment) /*-{
																	// decodeURI() does *not* decode the '#' character.
																	return decodeURI(encodedFragment.replace("%23", "#"));
																	}-*/;

	private native String encodeFragment(String fragment) /*-{
															// encodeURI() does *not* encode the '#' character.
															return encodeURI(fragment).replace("#", "%23");
															}-*/;

	@Override
	public void newItem(final String token, final boolean issueEvent) {
		log.debug("new Item");
		if (getToken().equals(token)) { // not sure if this is needed, but just
										// in case
			return;
		}
		// your own logic here to construct the new URI
		if (issueEvent) {
			pushState(token);
		} else {
			replaceState(token);
		}
		if (issueEvent) {
			ValueChangeEvent.fire(this, getToken());
		}
	}

	@Override
	public void fireEvent(final GwtEvent<?> event) {
		this.handlers.fireEvent(event);
	}

	private native void initEvent() /*-{
									var that = this;
									var oldHandler = $wnd.onpopstate;
									$wnd.onpopstate = $entry(function(e) {
									that.@com.calpano.common.client.history.Html5Historian::onPopState()();
									if (oldHandler) {
									oldHandler();
									}
									});
									}-*/;

	private void onPopState() {
		ValueChangeEvent.fire(this, getToken());
	}

	private native void pushState(String url) /*-{
												$wnd.history.pushState(null, $doc.title, url);
												}-*/;

	private native void replaceState(String url) /*-{
													$wnd.history.replaceState(null, $doc.title, url);
													}-*/;

	@Override
	public Place getPlace(final String token) {
		return Place.NOWHERE;
	}

	@Override
	public String getToken(final Place place) {
		return decodeFragment(Window.Location.getPath());
	}

	@Override
	public String getToken() {

		return decodeFragment(Window.Location.getPath());
	}
}
