package com.calpano.common.client.storage;

import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.rmof.impl.XExistsRevWritableModel;
import org.xydra.core.model.impl.memory.IMemoryModel;
import org.xydra.core.model.impl.memory.MemoryModel;
import org.xydra.core.model.impl.memory.sync.MemorySyncLog;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.json.JsonSerializer;

/**
 * Can store models as JSON in localStorage
 *
 * @author xamde
 */
public class MemoryModelStorage extends SingleKeyStorage<IMemoryModel> {

	private final XId actorId;
	private final String keyPrefix;
	private final XId repoId;
	private final String passwordHash;

	/**
	 * @param actorId
	 *            becomes part of the storage key
	 * @param repoId
	 * @param passwordHash
	 *            required when loading to be able to return a fully working
	 *            model
	 * @param keyPrefix
	 */
	public MemoryModelStorage(final XId actorId, final XId repoId, final String passwordHash, final String keyPrefix) {
		this.actorId = actorId;
		this.repoId = repoId;
		this.passwordHash = passwordHash;
		this.keyPrefix = keyPrefix;
	}

	@Override
	public String getKey() {
		return this.keyPrefix + "_" + this.actorId;
	}

	@Override
	protected String serialize(final IMemoryModel model) {

		final JsonSerializer serializer = new JsonSerializer();

		// serialize with revisions and local changes
		final XydraOut out = serializer.create();
		out.enableWhitespace(false, false);
		SerializedModel.serialize(model, out, true, true, true, true
		// ,true
				);

		final String data = out.getData();

		assert deserialize(data) != null;

		return data;
	}

	@Override
	protected MemoryModel deserialize(final String data) {
		final JsonParser parser = new JsonParser();
		final XydraElement xydraElement = parser.parse(data);
		final XExistsRevWritableModel model = SerializedModel.toModelState(xydraElement,
				Base.resolveRepository(this.repoId));

		// XChangeLogState changeLogState =
		// SerializedModel.loadChangeLogState(xydraElement,
		// model.getAddress());
		// List<XCommand> localChangesAsCommands =
		// SerializedModel.loadLocalChangesAsCommands(
		// xydraElement, model.getAddress());
		// long syncRev =
		// SerializedModel.getSyncRevisionAttribute(xydraElement);

		final MemorySyncLog syncLogState = new MemorySyncLog(model.getAddress());

		final XydraElement syncLogElement = xydraElement.getChild("synclog");
		SerializedModel.loadSyncLogState(syncLogElement, syncLogState.getSyncLogState());

		// NEWCORE
		final MemoryModel memoryModel = new MemoryModel(this.actorId, this.passwordHash, model,
				syncLogState.getSyncLogState());

		// OLDCORE
		// MemoryModel memoryModel = new MemoryModel(this.actorId,
		// this.passwordHash, null, model,
		// changeLogState, syncRev, true, localChangesAsCommands);
		return memoryModel;
	}
}
