package com.calpano.common.client.util;

import com.calpano.common.shared.util.SharedUrl;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window.Location;

/*
 * [ERROR] java.lang.AssertionError: url is
 * 'http:://localhost:8765/clientError/1346706797903?via=adminuserlist&btn=adminuserlist&gwt.codesvr=172.22.177.159'
 * and contains neither http(s):// nor mailto: debug=scheme=http: *
 * hostname=localhost * port=8765 * path=/clientError/1346706797903 *
 * query=via=adminuserlist&btn=adminuserlist&gwt.codesvr=172.22.177.159 * hash=
 */

public class ClientUrl extends SharedUrl {

	public ClientUrl(final String protocol, final String hostName, final String port, final String path,
			final String queryString, final String hashString) {
		super(protocol, hostName, port, path, queryString, hashString);
	}

	public static ClientUrl fromCurrentLocation() {
		// remove leading questionmark
		String queryString = Location.getQueryString();
		if (queryString != null && queryString.length() > 1) {
			queryString = queryString.substring(1);
		}
		// remove leading hash
		String fragment = Location.getHash();
		if (fragment != null && fragment.length() > 1) {
			fragment = fragment.substring(1);
		}
		final ClientUrl cu = new ClientUrl(Location.getProtocol(), Location.getHostName(),
				Location.getPort(), Location.getPath(), queryString, fragment);
		return cu;
	}

	/**
	 * @param name
	 * @param value
	 *            will be urlencoded
	 */
	public void addQueryParamAndEncodeValue(final String name, final String value) {
		final String enc = URL.encode(value);
		addQueryParam(name, enc);
	}

}
