package com.calpano.common.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.xydra.annotations.CanBeNull;

import com.calpano.common.client.util.SelectableDropDown.SelectableObject;
import com.calpano.common.client.view.forms.suggestion.ISuggestionDisplay;
import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager;
import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager.SuggestionCallback;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;

/**
 * An implementation of an {@link ISuggestionDisplay}, i.e. for displaying
 * suggestions
 *
 * <ul class="typeahead dropdownMenu" style="top: 24064px; left: 544px; display: block; ">
 *
 * <li data-value="Alabama" class="active"><a
 * href="#"><strong>A</strong>l<strong
 * >a</strong>b<strong>a</strong>m<strong>a</strong></a></li>
 * <li data-value="Alaska"><a
 * href="#"><strong>A</strong>l<strong>a</strong>sk<strong>a</strong></a></li>
 * <li data-value="Arizona"><a
 * href="#"><strong>A</strong>rizon<strong>a</strong></a></li>
 * <li data-value="Arkansas"><a
 * href="#"><strong>A</strong>rk<strong>a</strong>ns<strong>a</strong>s</a></li>
 *
 * </ul>
 *
 * @author xamde
 *
 */
public class SuggestionDisplay extends Composite implements ISuggestionDisplay {

	class Selectable implements SelectableObject {

		public Selectable(final Suggestion suggestion) {
			this.suggestion = suggestion;
		}

		final Suggestion suggestion;

		@Override
		public String getHtmlDisplayString() {
			return this.suggestion.getDisplayString();
		}

	}

	private final SelectableDropDown<Selectable> dropdown;

	public SuggestionDisplay() {
		this.dropdown = new SelectableDropDown<Selectable>();
		initWidget(this.dropdown);
		this.dropdown.addSelectionHandler(new SelectionHandler<SuggestionDisplay.Selectable>() {

			@Override
			public void onSelection(final SelectionEvent<Selectable> event) {
				SuggestionDisplay.this.suggestionManager.fireSuggestionActivated(event
						.getSelectedItem().suggestion);
			}
		});
	}

	private SuggestionManager suggestionManager;
	private boolean enabled;

	@Override
	@CanBeNull
	public Suggestion getCurrentSelection() {
		if (!this.enabled) {
			return null;
		}

		final Selectable s = this.dropdown.getCurrentSelection();
		return s == null ? null : s.suggestion;
	}

	@Override
	public void hideSuggestions() {
		this.dropdown.hide();
	}

	@Override
	public void moveSelectionDown() {
		if (!this.enabled) {
			return;
		}

		this.dropdown.moveSelectionDown();
	}

	@Override
	public void moveSelectionUp() {
		if (!this.enabled) {
			return;
		}

		this.dropdown.moveSelectionUp();
	}

	@Override
	public void showSuggestions(final SuggestionManager suggestionManager,
			final Collection<? extends Suggestion> suggestions, final boolean isAutoSelectEnabled,
			final SuggestionCallback callback, final boolean hasMoreSuggestions, final int numMoreSuggestions) {
		if (!this.enabled) {
			return;
		}

		this.suggestionManager = suggestionManager;

		final List<Selectable> items = new ArrayList<Selectable>();
		for (final Suggestion sugg : suggestions) {
			items.add(new Selectable(sugg));
		}
		this.dropdown.positionBelow(suggestionManager.getTextBoxBase());
		this.dropdown.show(items, isAutoSelectEnabled ? 0 : -1);
	}

	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
	}

}
