package com.calpano.common.client.view;

import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 *
 * @author xamde
 */
public class Closer extends FocusPanel implements ClickHandler {

	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(Closer.class);

	public static interface Closable {
		public void onClose();
	}

	private final Closable closable;

	public Closer(final Closable closable, final Widget widget) {
		super(widget);
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		this.closable = closable;
		addClickHandler(this);
		addStyleName(CommonResourceBundle.INSTANCE.css().close());

	}

	public Closer(final Closable closable) {
		super();
		this.closable = closable;
		addClickHandler(this);
		addStyleName(CommonResourceBundle.INSTANCE.css().close());

	}

	@Override
	public void onClick(final ClickEvent event) {
		final Widget sender = (Widget) event.getSource();
		if (sender == this) {
			this.closable.onClose();
		}

	}

}
