package com.calpano.common.client.view.forms;

/**
 * Fired on submit-success, on submit-failed, and on reset events.
 *
 * Flow:
 *
 * <pre>
 * browser event or call triggers form.tryToSubmit()
 *
 * IF all inputs are valid:
 * 1) fire all input.onJustBeforeFormSubmit
 * 2a) formSubmitter.submitForm()
 * 2b) formsubmitter must call: form.onFailure() or form.onSuccess()
 * 2b.1) onFailure -> all input.onFormSubmitFailed()
 * 2b.2) onSuccess: all input.onFormReset()
 *
 * ELSE: showValidationWarnings and focus on first wrong input
 *
 * </pre>
 */
public interface IFormSubmitEventHandler {

	/**
	 * Fired just before the form is submitted. All child widgets are locked.
	 * Maybe you want to lock something else, too.
	 */
	void onJustBeforeFormSubmit();

	/**
	 * Called when submit is done successfully. Remember to unlock() now if you
	 * locked before.
	 */
	void onFormSubmitSuccess();

	/**
	 * Submit failed. Remember to unlock() now if you locked before.
	 */
	void onFormSubmitFailed();

}
