package com.calpano.common.client.view.forms.activation;

import com.google.web.bindery.event.shared.HandlerRegistration;

/**
 * A widget that implements this interface provides registration for
 * {@link ActivationHandler} instances.
 */
public interface HasActivationHandlers {
	/**
	 * Adds a {@link ActivationEvent} handler.
	 *
	 * @param handler
	 * @return {@link HandlerRegistration} used to remove this handler
	 */
	HandlerRegistration addActivationHandler(ActivationHandler handler);
}
