package com.calpano.common.client.view.forms.impl;

import org.xydra.annotations.Feature;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.client.view.forms.IBelongsToHtml5Form;
import com.calpano.common.client.view.forms.locking.ILockable;
import com.calpano.common.client.view.forms.locking.impl.LockUtils;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Button;

/**
 * On click, it submits the {@link Html5FormPanel}, if it has one.
 *
 * Renders lock() by adding a spinner inside the button.
 */
public class Html5SubmitButton extends Button implements IBelongsToHtml5Form, ILockable {

	private static final Logger log = LoggerFactory.getLogger(Html5SubmitButton.class);

	private boolean disabled = false;

	private Html5FormPanel form;

	public Html5SubmitButton() {
		super();
		/*
		 * You need to 'sink' (register for) the events you want
		 */
		sinkEvents(Event.ONCLICK | Event.ONDBLCLICK | Event.ONKEYPRESS | Event.ONKEYUP);
	}

	@Override
	public Html5FormPanel getForm() {
		return this.form;
	}

	@Override
	@Feature("locking")
	public void lock() {
		LockUtils.lock(this);
	}

	@Override
	public void onBrowserEvent(final Event event) {
		super.onBrowserEvent(event);

		if (!isEnabled()) {
			log.warn("rejected click on disabled button");
			return;
		}

		switch (event.getTypeInt()) {
		// TODO keypress+keyup OR keydown?
		case Event.ONKEYDOWN:
		case Event.ONKEYPRESS:
		case Event.ONKEYUP:
			if (event.getKeyCode() != KeyCodes.KEY_ENTER) {
				break;
			}
			//$FALL-THROUGH$
		case Event.ONCLICK:
		case Event.ONDBLCLICK:
			this.form.tryToSubmit(this);
			break;
		}
	}

	@Override
	@Feature("locking")
	public void resetLockState() {
		setEnabled(!this.disabled);
	}

	/**
	 * Support initially setting the disabled-flag via UiBinder
	 *
	 * @param attributeValue
	 */
	public void setDisabled(final String attributeValue) {
		final boolean disabled = attributeValue.equals("disabled") || attributeValue.equals("");
		setEnabled(!disabled);
	}

	@Override
	public void setForm(final Html5FormPanel html5FormPanel) {
		this.form = html5FormPanel;
	}

	@Override
	@Feature("locking")
	public void unlock() {
		LockUtils.unlock(this);
	}

	@Override
	public void setEnabled(final boolean enabled) {
		CommonResourceBundle.INSTANCE.css().ensureInjected();
		/* prevent this from reaching the DOM, we just simulate it */
		this.disabled = !enabled;
		if (this.disabled) {
			addStyleName(CommonResourceBundle.INSTANCE.css().disabled());
		} else {
			removeStyleName(CommonResourceBundle.INSTANCE.css().disabled());
		}
	}

	@Override
	public boolean isEnabled() {
		return !this.disabled;
	}

}
