package com.calpano.common.client.view.forms.locking.impl;

import org.xydra.annotations.Feature;

import com.calpano.common.client.view.forms.locking.ILockable;
import com.calpano.common.client.view.resources.Css;
import com.google.gwt.user.client.ui.TextBoxBase;

/**
 *
 * <h3>Listens to Events</h3> None
 *
 * <h3>Fires events</h3> None
 *
 * <h3>On reset</h3> unlock
 *
 * <h3>CSS attributes or JavaScript flags changed</h3> {@link Css#locked()}
 *
 * @author xamde
 *
 * @param <T>
 */
public class H5Lockable<T extends TextBoxBase> implements ILockable {

	protected T base;

	public H5Lockable(final T base) {
		this.base = base;
	}

	@Override
	@Feature("locking")
	public void resetLockState() {
		unlock();
	}

	@Override
	@Feature("locking")
	public void unlock() {
		LockUtils.unlock(this.getTextBoxBase());
	}

	@Override
	@Feature("locking")
	public void lock() {
		LockUtils.lock(this.getTextBoxBase());
	}

	public T getTextBoxBase() {
		return this.base;
	}

	protected void reset() {
		resetLockState();
	}

	protected void onLoad() {
	}

	/**
	 * @return the bit field of events to be used in sinkEvents. This lets
	 *         sub-components register for the appropriate events only.
	 */
	protected int getEventsToSink() {
		return 0;
	}

}
