package com.calpano.common.client.view.forms.suggestion;

import java.util.Collection;

import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager;
import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager.SuggestionCallback;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;

public interface ISuggestionDisplay {

	/**
	 * Get the currently selected {@link Suggestion} in the display.
	 *
	 * @return the current suggestion, or null if none selected
	 */
	Suggestion getCurrentSelection();

	/**
	 * Hide the list of suggestions from view.
	 */
	void hideSuggestions();

	/**
	 * Highlight the suggestion directly below the current selection in the
	 * list.
	 */
	void moveSelectionDown();

	/**
	 * Highlight the suggestion directly above the current selection in the
	 * list.
	 */
	void moveSelectionUp();

	/**
	 * Update the list of visible suggestions.
	 *
	 * @param suggestBox
	 *            the suggest box where the suggestions originated
	 * @param suggestions
	 *            the suggestions to show
	 * @param isAutoSelectEnabled
	 *            if true, the first item should be selected automatically
	 * @param callback
	 *            the callback used when the user makes a suggestion
	 * @param hasMoreSuggestions
	 *            true if more matches were available
	 * @param numMoreSuggestions
	 *            number of more matches available. If the specific number is
	 *            unknown, 0 will be passed.
	 */
	void showSuggestions(SuggestionManager suggestBox,
			Collection<? extends Suggestion> suggestions, boolean isAutoSelectEnabled,
			SuggestionCallback callback, boolean hasMoreSuggestions, int numMoreSuggestions);

}
