package com.calpano.common.client.view.forms.utils;

import com.google.gwt.event.dom.client.KeyCodes;

public class KeyUtils {

	/** Keycodes that let the browser leave the current input field */
	public static final int[] MOVE_AWAY_KEYCODES = new int[] { KeyCodes.KEY_TAB };

	public static final int MAC_COMMAND_LEFT_FIREFOX = 224;

	public static final int MAC_COMMAND_LEFT_WEBKIT = 91;

	public static final int MAC_COMMAND_RIGHT = 93;

	public static final int CAPS_LOCK = 20;

	public static final int F1 = 112;
	public static final int F2 = 113;
	public static final int F3 = 114;
	public static final int F4 = 115;
	public static final int F5 = 116;
	public static final int F6 = 117;
	public static final int F7 = 118;
	public static final int F8 = 119;
	public static final int F9 = 120;
	public static final int F10 = 121;
	public static final int F11 = 122;
	public static final int F12 = 123;

	public static final int WIN_LEFT_WINDOWS_KEY = 91;
	public static final int WIN_RIGHT_WINDOWS_KEY = 92;

	/** Keycodes that let the browser produce no text */
	public static final int[] NONTEXT_KEYCODES = new int[] { KeyCodes.KEY_BACKSPACE,
			KeyCodes.KEY_DELETE, KeyCodes.KEY_RIGHT, KeyCodes.KEY_LEFT, KeyCodes.KEY_DOWN,
			KeyCodes.KEY_UP, KeyCodes.KEY_HOME, KeyCodes.KEY_END,

			KeyCodes.KEY_SHIFT, KeyCodes.KEY_CTRL, KeyCodes.KEY_ALT, MAC_COMMAND_LEFT_FIREFOX,
			MAC_COMMAND_LEFT_WEBKIT, MAC_COMMAND_RIGHT,

			WIN_LEFT_WINDOWS_KEY, WIN_RIGHT_WINDOWS_KEY,

			KeyCodes.KEY_ESCAPE, KeyCodes.KEY_PAGEDOWN, KeyCodes.KEY_PAGEUP,

			CAPS_LOCK, F1, F2, F3, F4, F5, F6, F7, F8, F9, F10, F11, F12

	};

	private static final int KEYCODE_A = 65;

	private static final int KEYCODE_Z = 90;

	public static boolean producesText(final int keyCode) {
		/* swallow movement keys and clicks of modifier keys */
		if (keyCode >= KEYCODE_A && keyCode <= KEYCODE_Z) {
			// fast way to find out this key is producing text
			return true;
		} else if (oneOf(keyCode, NONTEXT_KEYCODES)) {
			return false;
		}
		/* tab key-down is fired in field before focus switched */
		else if (keyCode == KeyCodes.KEY_TAB) {
			return false;
		} else {
			/* all other keys count */
			return true;
		}
	}

	/**
	 * @param a
	 * @param b
	 * @return true if a one of the elements in b
	 */
	public static boolean oneOf(final int a, final int[] b) {
		for (int i = 0; i < b.length; i++) {
			if (a == b[i]) {
				return true;
			}
		}
		return false;
	}

}
