package com.calpano.common.client.view.hover;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.NeverNull;

import com.calpano.common.client.ClientApp;
import com.calpano.common.shared.util.CommonAppState.Is;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class HoverEvent extends Event<HoverHandler> {

	private final NativeEvent cause;
	private final boolean hoverStart;

	/**
	 * @param cause for debugging, @CanBeNull
	 * @param hoverStart if true, the hover just starts. If false, the hover
	 *            just ended.
	 */
	public HoverEvent(final NativeEvent cause, final boolean hoverStart) {
		this.cause = cause;
		this.hoverStart = hoverStart;
	}

	/**
	 * @return null if no browser event was the cause
	 */
	public NativeEvent getCause() {
		return this.cause;
	}

	public boolean isHoverStart() {
		return this.hoverStart;
	}

	public boolean isHoverEnd() {
		return !this.hoverStart;
	}

	public static Type<HoverHandler> TYPE = new Type<HoverHandler>();

	public static Type<HoverHandler> getTYPE() {
		return TYPE;
	}

	@Override
	public Type<HoverHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public Widget getSource() {
		return (Widget) super.getSource();
	}

	@Override
	protected void dispatch(final HoverHandler handler) {
		handler.onHoverChange(this);
	}

	public static void fireHoverStartFromSource(@NeverNull final HasHoverHandlers source,
			@CanBeNull final NativeEvent cause) {
		if (source.getLastHoverFired() != Is.Yes) {
			ClientApp.getEventBus().fireEventFromSource(new HoverEvent(cause, true), source);
			source.setLastHoverFired(Is.Yes);
		}
	}

	public static void fireHoverEndFromSource(@NeverNull final HasHoverHandlers source,
			@CanBeNull final NativeEvent cause) {
		if (source.getLastHoverFired() != Is.No) {
			ClientApp.getEventBus().fireEventFromSource(new HoverEvent(cause, false), source);
			source.setLastHoverFired(Is.No);
		}
	}

	public static HandlerRegistration addHandler(final Object source, final HoverHandler handler) {
		return ClientApp.getEventBus().addHandlerToSource(TYPE, source, handler);
	}

	public static void registerHoverEventsOn(final HasHoverHandlers hhh) {
		hhh.asWidget().addDomHandler(new MouseOverHandler() {

			@Override
			public void onMouseOver(final MouseOverEvent event) {
				final HasHoverHandlers hhh = (HasHoverHandlers) event.getSource();
				fireHoverStartFromSource(hhh, event.getNativeEvent());
			}
		}, MouseOverEvent.getType());

		hhh.asWidget().addDomHandler(new MouseOutHandler() {

			@Override
			public void onMouseOut(final MouseOutEvent event) {
				final HasHoverHandlers hhh = (HasHoverHandlers) event.getSource();
				fireHoverEndFromSource(hhh, event.getNativeEvent());
			}
		}, MouseOutEvent.getType());

		// FIXME UI HOVER !!!
		// hhh.asWidget().addDomHandler(new ClickHandler() {
		//
		// @Override
		// public void onClick(ClickEvent event) {
		// HasHoverHandlers hhh = (HasHoverHandlers)event.getSource();
		// fireHoverStartFromSource(hhh, event.getNativeEvent());
		// }
		// }, ClickEvent.getType());
	}
}
