package com.calpano.common.client.view.hover;

/**
 * Fires when an input element is activated or deactivated. Never fires
 * activated twice without a deactivated in between.
 *
 * Focus is broken on browsers and implemented too differently. This is an
 * abstraction.
 *
 * Activation: Element is focus and not left within n milliseconds afterwards.
 * Element is clicked on.
 *
 * Deactivation: Element looses focus.
 *
 *
 * Impl note: Invented because Chrome 21 sends an onFocus/onBlur event pair
 * whenever a form is added to the DOM or submitted.
 *
 */
public interface HoverHandler {

	/**
	 * Fired when input becomes activated by clicking on it or typing in it.
	 *
	 * @param event
	 */
	void onHoverChange(HoverEvent event);

}
