package com.calpano.common.shared.user;

import org.xydra.annotations.RunsInGWT;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.UUID;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.URLUtils;

@RunsInGWT(true)
public class ViralUtils {

	private static final Logger log = LoggerFactory.getLogger(ViralUtils.class);

	/**
	 * @return a 7-char string
	 */
	public static XId createRandomShortId() {
		return Base.toId("s" + UUID.uuid(6, 62));
	}

	/**
	 * @param model
	 *            ..
	 * @return a unique objectId in the given model
	 */
	public static XId createUniqueShortObjectId(final XReadableModel model) {
		XId shortId = createRandomShortId();
		int attempts = 0;
		while (model.getObject(shortId) != null && attempts++ <= 100) {
			shortId = createRandomShortId();
		}
		if (attempts >= 100) {
			log.error("Could not create another distinct short id, last attempt " + shortId);
		}
		return shortId;
	}

	/**
	 * @param url
	 *            ..
	 * @param via
	 *            twitter account name
	 * @param text
	 *            max. 140 chars
	 * @return a URL
	 */
	public static String getTwitterUrl(final String url, final String via, final String text) {
		final String url_enc = URLUtils.encode(url);
		final String via_enc = URLUtils.encode(via);
		final String text_enc = URLUtils.encode(text);
		return "http://twitter.com/share?" + "url=" + url_enc + "&amp;via=" + via_enc
				+ "&amp;text=" + text_enc;
	}

}
