package com.calpano.common.shared.user.base;

import org.xydra.annotations.CanBeNull;
import org.xydra.base.XId;

import com.calpano.common.shared.user.INameEmailUser;

/**
 * Stuff for users shared with a logged-in user. Only some attributes of a user
 * are readable. Very few (or none?) are writable.
 *
 * @author xamde
 *
 */
public interface ISharedBaseUserService {

	/**
	 * @param userId
	 * @return the user shared with the currently logged-in user or null if not
	 *         available. Also null if not yet loaded. TODO define loading
	 */
	@CanBeNull
	INameEmailUser getUserById(XId userId);

	/**
	 * @param email
	 *            casing is ignored, can be a primary or secondary email
	 * @return null if not found
	 */
	@CanBeNull
	INameEmailUser getUserByEmail(String email);

}
