package com.calpano.common.shared.user.wrapper;

import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;
import com.calpano.common.shared.xydrautils.field.FieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

public class AuthenticationUser extends BasedOnXWritableObject implements IBasedOnXWritableObject {

	private static final long serialVersionUID = 1L;

	private static FieldProperty<String> _authToken = new FieldProperty<String>("authToken",
			String.class);

	private static FieldProperty<String> _password = new FieldProperty<String>("password",
			String.class);

	public AuthenticationUser(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	public void setAuthToken(final String authToken) {
		_authToken.setValue(getActorId(), getXWritableObject(), authToken);
	}

	/**
	 * @return the user xobject id if no authToken has been set
	 */
	public String getAuthToken() {
		final String authToken = _authToken.getValue(getXObject());
		return authToken == null ? getXObject().getId().toString() : authToken;
	}

	/**
	 * @return null if none is defined FIXME store password HASH instead of
	 *         password
	 */
	public String getPassword() {
		return _password.getValue(getXObject());
	}

	public void setPassword(final String password) {
		_password.setValue(getActorId(), getXWritableObject(), password);
	}

}
