package com.calpano.common.shared.user.wrapper;

import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;
import com.calpano.common.shared.xydrautils.field.FieldProperty;
import com.calpano.common.shared.xydrautils.field.XIntegerFieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

public class ManagedUser extends BasedOnXWritableObject implements IBasedOnXWritableObject {

	private static final long serialVersionUID = 1L;

	private static FieldProperty<String> _adminComment = new FieldProperty<String>("adminComment",
			String.class);

	private static final XIntegerFieldProperty _schemaVersion = new XIntegerFieldProperty(
			"_schemaVersion");

	public ManagedUser(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	/**
	 * @return a generic string that is never shown to users and can be changed
	 *         in an admin gui
	 */
	public String getAdminComment() {
		return _adminComment.getValue(getXObject());
	}

	public int getSchemaVersion() {
		return _schemaVersion.getValue(getXObject());
	}

	public void setAdminComment(final String adminComment) {
		_adminComment.setValue(getActorId(), getXObject(), adminComment);
	}

	public void setSchemaVersion(final int version) {
		_schemaVersion.setValue(getActorId(), getXObject(), version);
	}

}
