package com.calpano.common.shared.user.wrapper;

import org.xydra.annotations.CanBeNull;
import org.xydra.annotations.Template;

import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;
import com.calpano.common.shared.xydrautils.StringSetWrapper;
import com.calpano.common.shared.xydrautils.field.DateTimeFieldProperty;
import com.calpano.common.shared.xydrautils.field.FieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

import de.xam.p13n.shared.time.MiniDateTime;

public class MetricUser extends BasedOnXWritableObject implements IBasedOnXWritableObject {

	private static final long serialVersionUID = 1L;

	/** lazy initialised. See {@link #getFirstMailSent()} */
	public static FieldProperty<Long> _firstMailSent = new FieldProperty<Long>("firstMailSent",
			Long.class);

	/** lazy initialised. See {@link #getLastMailSent()} */
	public static FieldProperty<Long> _lastMailSent = new FieldProperty<Long>("lastMailSent",
			Long.class);

	/** always initialised. Creation date. See {@link #getCreationDate()} */
	public static final FieldProperty<Long> _creationDate = new FieldProperty<Long>(
			"_creationDate", Long.class);

	public static FieldProperty<String> _creationSource = new FieldProperty<String>(
			"creationSource", String.class);

	public static final DateTimeFieldProperty _firstVisit = new DateTimeFieldProperty("firstVisit");

	public static final FieldProperty<Long> _firstWebVisit = new FieldProperty<Long>(
			"firstWebVisit", Long.class);

	public static final FieldProperty<Long> _ga31bitId = new FieldProperty<Long>("ga31bitId",
			Long.class);

	public static final DateTimeFieldProperty _lastVisit = new DateTimeFieldProperty("lastVisit");

	/** lazy initialised. */
	public static FieldProperty<String> _promoCode = new FieldProperty<String>("promoCode",
			String.class);

	public static final FieldProperty<Integer> _sessionCount = new FieldProperty<Integer>(
			"sessionCount", Integer.class);

	public MetricUser(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	/**
	 * @return UTC time of user creation
	 */
	@Template("creation date - timepoint when the user has been created")
	public long getCreationDate() {
		return _creationDate.getValue(getXObject());
	}

	/**
	 * @return source or reason for creating this
	 */
	@CanBeNull
	public String getCreationSource() {
		return _creationSource.getValue(getXObject());
	}

	/**
	 * @return the date of the first visit ever, or null if none.
	 */
	public MiniDateTime getFirstVisitDate() {
		return _firstVisit.getValue(getXObject());
	}

	/**
	 * @return dateOfFirstWebVisit as reported from Google Analytics
	 */
	public long getFirstWebVisitDate() {
		return _firstWebVisit.getValue(getXObject());
	}

	/**
	 * Note: you can use
	 * org.xydra.googleanalytics.SharedUtils#random31bitInteger() to generate a
	 * valid id.
	 *
	 * @return the defined Google Analytics 31 bit Id, or 0 if not defined.
	 */
	public long getGa31BitId() {
		final long id = _ga31bitId.getValue(getXObject());
		return id;
	}

	/**
	 * @return the date of the last visit or null if not computed. Together with
	 *         {@link #getLastMailSent()} this allows a pretty accurate
	 *         estimation of the last time this user was active.
	 */
	public MiniDateTime getLastVisitDate() {
		return _lastVisit.getValue(getXObject());
	}

	/**
	 * @return a promoCode used at invitation time or null
	 */
	public String getPromoCode() {
		return _promoCode.getValue(getXObject());
	}

	/**
	 * @return the number of sessions. A session is any sequence of visits that
	 *         has less than 30 minutes of pause between actions. This takes
	 *         only server-actions (i.e. service calls) into account.
	 */
	public int getSessionCount() {
		return _sessionCount.getValue(getXObject());
	}

	public void incrementSessionCount() {
		final int sessionCount = getSessionCount();
		_sessionCount.setValue(getActorId(), getXObject(), sessionCount + 1);
	}

	/**
	 * Use only for backup-restore operations!
	 *
	 * @param creationDate
	 *            in UTC
	 */
	public void setCreationDate(final long creationDate) {
		_creationDate.setValue(getActorId(), getXWritableObject(), creationDate);
	}

	/**
	 * @param source
	 *            or reason for creating this
	 */
	public void setCreationSource(final String source) {
		_creationSource.setValue(getActorId(), getXObject(), source);
	}

	public void setFirstVisitDate(final MiniDateTime dateOfFirstVisit) {
		_firstVisit.setValue(getActorId(), getXObject(), dateOfFirstVisit);
	}

	/**
	 * @param dateOfFirstWebVisit
	 *            as reported from Google Analytics
	 */
	public void setFirstWebVisitDate(final long dateOfFirstWebVisit) {
		_firstWebVisit.setValue(getActorId(), getXObject(), dateOfFirstWebVisit);
	}

	public void setGa31BitId(final long ga31bitId) {
		_ga31bitId.setValue(getActorId(), getXObject(), ga31bitId);
	}

	public void setLastVisitDate(final MiniDateTime dateOfLastVisit) {
		_lastVisit.setValue(getActorId(), getXObject(), dateOfLastVisit);
	}

	public void setPromoCode(final String promoCode) {
		_promoCode.setValue(getActorId(), getXObject(), promoCode);
	}

	public StringSetWrapper asUserAgents() {
		return new StringSetWrapper(this, "userAgents");
	}

	/**
	 * Should only be used in tests.
	 *
	 * @param sessionCount
	 */
	public void setSessionCount(final int sessionCount) {
		_sessionCount.setValue(getActorId(), getXObject(), sessionCount);
	}

	/**
	 * @return the first time when an email has successfully been sent (at least
	 *         from GAEs point of view) in UTC milliseconds. 0 if no mail has
	 *         been sent.
	 */
	public long getFirstMailSent() {
		long result = _firstMailSent.getValue(getXObject());
		// IMPROVE remove auto-fix
		if (result == 0) {
			result = getLastMailSent();
			if (result != 0) {
				setFirstMailSent(result);
			}
		}
		return result;
	}

	/**
	 * @return the last time when an email has successfully been sent in UTC
	 *         milliseconds. 0 if no mail has been sent.
	 */
	public long getLastMailSent() {
		return _lastMailSent.getValue(getXObject());
	}

	/**
	 * @param lastMailSent
	 *            a datetime in UTC
	 */
	public void setLastMailSent(final long lastMailSent) {
		_lastMailSent.setValue(getActorId(), getXObject(), lastMailSent);
	}

	/**
	 * @param firstMailSent
	 *            a datetime in UTC
	 */
	public void setFirstMailSent(final long firstMailSent) {
		_firstMailSent.setValue(getActorId(), getXObject(), firstMailSent);
	}
}
