package com.calpano.common.shared.util;

import java.util.concurrent.ConcurrentLinkedQueue;

import org.xydra.annotations.RunsInGWT;

/**
 * Runs in GWT via super-source, concurrently in standard Java otherwise.
 *
 * @author xamde
 *
 * @param <T>
 */
@RunsInGWT(true)
public class QueueGwtEmul<T> implements Queue<T> {

	private final java.util.Queue<T> q = new ConcurrentLinkedQueue<T>();

	/**
	 * @param size
	 *            initial buffer size, if applicable
	 */
	public QueueGwtEmul(final int size) {
	}

	@Override
	public void enqueue(final T element) {
		this.q.add(element);
	}

	@Override
	public boolean isEmpty() {
		return this.q.isEmpty();
	}

	@Override
	public T peek() {
		return this.q.peek();
	}

	@Override
	public T poll() {
		return this.q.poll();
	}

}
