package com.calpano.common.shared.xydrautils;

import java.util.Set;

import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

import com.calpano.common.shared.xydrautils.field.StringSetFieldProperty;
import com.calpano.common.shared.xydrautils.impl.BasedOnXWritableObject;

/**
 * Wraps any {@link XWritableObject} to support tagging
 *
 * @author xamde
 *
 */
public class TaggedObject extends BasedOnXWritableObject {

	private static final long serialVersionUID = 1L;
	@SuppressWarnings("unused")
	private static final Logger log = LoggerFactory.getLogger(TaggedObject.class);

	public TaggedObject(final XWritableObject xo, final XId actorId) {
		super(xo, actorId);
	}

	public TaggedObject(final IBasedOnXWritableObject proto) {
		super(proto);
	}

	/** always initialised. See {@link #getTags()} */
	private static StringSetFieldProperty _tags = new StringSetFieldProperty("tags");

	/**
	 * @param tag
	 *            containing usually no spaces or commas -- here both is
	 *            permitted
	 */
	public void addTag(final String tag) {
		_tags.addToCollection(getActorId(), getXObject(), tag);
	}

	/**
	 * @return never null
	 */
	public Set<String> getTags() {
		return _tags.getValue(getXObject());
	}

	public boolean hasTag(final String tag) {
		return getTags().contains(tag);
	}

	public void removeTag(final String tag) {
		_tags.removeFromCollection(getActorId(), getXObject(), tag);
	}

}
