package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.BaseRuntime;
import org.xydra.base.value.XIntegerValue;

/**
 * Null is returned as '0'
 *
 * @author xamde
 */
public class XIntegerFieldProperty extends ExtensibleFieldProperty<Integer, XIntegerValue> {

	public XIntegerFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<Integer, XIntegerValue>() {

			@Override
			public Integer toJavaType(final XIntegerValue xydraType) {
				if (xydraType == null) {
					return 0;
				} else {
					return xydraType.contents();
				}
			}

			@Override
			public XIntegerValue toXydraValue(final Integer anyType) {
				return BaseRuntime.getValueFactory().createIntegerValue(anyType);
			}

		});
	}

}
