package com.calpano.common.shared.xydrautils.field;

import org.xydra.base.BaseRuntime;
import org.xydra.base.value.XLongValue;

/**
 * Null is returned as '0'
 *
 * @author xamde
 * @deprecated use {@link FieldProperty}<Long> instead.
 */
@Deprecated
public class XLongFieldProperty extends ExtensibleFieldProperty<Long, XLongValue> {

	public XLongFieldProperty(final String fieldIdString) {
		super(fieldIdString, new Converter<Long, XLongValue>() {

			@Override
			public Long toJavaType(final XLongValue xydraType) {
				if (xydraType == null) {
					return (long) 0;
				} else {
					return xydraType.contents();
				}
			}

			@Override
			public XLongValue toXydraValue(final Long anyType) {
				return BaseRuntime.getValueFactory().createLongValue(anyType);
			}

		});
	}

}
