package com.calpano.common.shared.xydrautils.impl;

import org.xydra.annotations.RunsInGWT;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableObject;

import com.calpano.common.shared.xydrautils.IBasedOnXWritableObject;

/**
 * Straight implementation of {@link IBasedOnXWritableObject} interface.
 *
 * Holds an {@link XWritableObject} reference.
 *
 * @author xamde
 */
@RunsInGWT(true)
public class BasedOnXWritableObject extends BasedOnXReadableObject implements
		IBasedOnXWritableObject {

	private static final long serialVersionUID = 9214135195087574094L;

	protected XId actorId;

	private XWritableObject writableObject;

	/**
	 * GWT-only constructor for serialisation.
	 */
	protected BasedOnXWritableObject() {
		super();
	}

	public BasedOnXWritableObject(final IBasedOnXWritableObject proto) {
		this(proto.getXWritableObject(), proto.getActorId());
	}

	public BasedOnXWritableObject(final XWritableObject xo, final XId actorId) {
		this.writableObject = xo;
		this.actorId = actorId;
		this.readableObject = this.writableObject;
	}

	@Override
	public XWritableObject getXObject() {
		return this.writableObject;
	}

	@Override
	public XId getActorId() {
		return this.actorId;
	}

	@Override
	public XWritableObject getXWritableObject() {
		return this.writableObject;
	}

}
