package de.xam.p13n.shared;

import java.io.Serializable;

import org.xydra.annotations.RequiresAppEngine;
import org.xydra.annotations.RunsInAppEngine;
import org.xydra.annotations.RunsInGWT;

/**
 * Small POJO to be used in GWT where java Locale would be desired.
 *
 * @author xamde
 *
 */
@RunsInAppEngine(true)
@RunsInGWT(true)
@RequiresAppEngine(false)
public class MiniLocale implements Serializable {

	private static final long serialVersionUID = -7118237432961172658L;
	public static final MiniLocale CANADA = new MiniLocale("en", "ca");
	public static final MiniLocale De_DE = new MiniLocale("de", "de");
	public static final MiniLocale EN_US = new MiniLocale("en", "us");
	public static final MiniLocale ENGLISH = new MiniLocale("en");
	public static final MiniLocale UK = new MiniLocale("en", "gb");

	private String country;

	private String language;

	private String variant;

	/** for GWT only */
	public MiniLocale() {
	}

	public MiniLocale(final String language) {
		this.language = language;
	}

	public MiniLocale(final String language, final String country) {
		this.language = language;
		this.country = country;
	}

	public MiniLocale(final String language, final String country, final String variant) {
		this.language = language;
		this.country = country;
		this.variant = variant;
	}

	public String getCountry() {
		return this.country;
	}

	/**
	 * @return the two-letter language code, e.g. 'de' or 'en'
	 */
	public String getLanguage() {
		return this.language;
	}

	/**
	 * @return e.g. 'us' or 'ca'
	 */
	public String getVariant() {
		return this.variant;
	}

	@Override
	public String toString() {
		return SharedLocaleUtils.toString(this, 3);
	}

	/**
	 * @param localeCode
	 *            format: 'en_gb_funny' or 'en_gb' or just 'en'.
	 * @return a {@link MiniLocale} or
	 * @throws IllegalArgumentException
	 *             if parsing failed
	 */
	public static MiniLocale fromLocaleCode(final String localeCode) {
		final String[] localParts = localeCode.split("_");
		if (localParts.length == 1) {
			return new MiniLocale(localParts[0]);
		} else if (localParts.length == 2) {
			return new MiniLocale(localParts[0], localParts[1]);
		} else if (localParts.length == 3) {
			return new MiniLocale(localParts[0], localParts[1], localParts[2]);
		} else {
			throw new IllegalArgumentException("Encountered locale-def with wrong format '"
					+ localeCode + "'");
		}
	}

}
