package de.xam.p13n.shared;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.xydra.annotations.RunsInGWT;

/**
 * A helper class to register requested but not present message keys together
 * with desired {@link Personalisation}.
 *
 * @author xamde
 *
 */
@RunsInGWT(true)
public class MissingMessageKeys {

	private static class PersonalisedMessageBundleList extends HashSet<PersonalisedMessageBundle> {
		private static final long serialVersionUID = -4733773242917233134L;

		@Override
		public String toString() {
			final StringBuffer buf = new StringBuffer();
			for (final PersonalisedMessageBundle pmb : this) {
				buf.append(pmb.toString() + ",");
			}
			return buf.toString();
		}
	}

	private static Map<String, PersonalisedMessageBundleList> map = new HashMap<String, PersonalisedMessageBundleList>();

	public static PersonalisedMessageBundleList get(final String missingKey) {
		return map.get(missingKey);
	}

	public static Map<String, PersonalisedMessageBundleList> map() {
		return map;
	}

	public static void put(final String key, final PersonalisedMessageBundle personalisedMessageBundle) {
		PersonalisedMessageBundleList entry = map.get(key);
		if (entry == null) {
			entry = new PersonalisedMessageBundleList();
			map.put(key, entry);
		}
		entry.add(personalisedMessageBundle);
	}

}
