package de.xam.p13n.shared.time;

import java.sql.Date;

import org.xydra.annotations.RunsInGWT;

/**
 * MiniLocalDate is an immutable datetime class representing a date without a
 * time zone - just like in JodaTime.
 *
 * For calculations see com.google.gwt.user.datepicker.client.CalendarUtil
 *
 * @author xamde
 */
@RunsInGWT(true)
public class MiniLocalDate {

	private transient Date date;

	private final long millis;

	/**
	 * Constructs an instance set to the specified date and time using
	 * <code>ISOChronology</code>.
	 *
	 * @param year
	 *            the year
	 * @param monthOfYear
	 *            the month of the year
	 * @param dayOfMonth
	 *            the day of the month
	 */
	@SuppressWarnings("deprecation")
	public MiniLocalDate(final int year, final int monthOfYear, final int dayOfMonth) {
		final Date date = new Date(year - 1900, monthOfYear - 1, dayOfMonth);
		this.date = date;
		this.millis = date.getTime();
	}

	public MiniLocalDate(final long millis) {
		this.millis = millis;
	}

	@Override
	public boolean equals(final Object other) {
		return other instanceof MiniLocalDate && ((MiniLocalDate) other).millis == this.millis;
	}

	@SuppressWarnings("deprecation")
	public int getDayOfMonth() {
		lazyInitDate();
		return this.date.getDate();
	}

	public long getMillis() {
		return this.millis;
	}

	@SuppressWarnings("deprecation")
	public int getMonthOfYear() {
		lazyInitDate();
		return this.date.getMonth() + 1;
	}

	@SuppressWarnings("deprecation")
	public int getYear() {
		lazyInitDate();
		return this.date.getYear() + 1900;
	}

	@Override
	public int hashCode() {
		return new Long(this.millis).hashCode();
	}

	private void lazyInitDate() {
		if (this.date == null) {
			this.date = new Date(this.millis);
		}
	}

	public MiniDateTime toDateTimeAtStartOfDay() {
		return new MiniDateTime(getMillis());
	}

	/** @return ISO8601 date */
	@Override
	public String toString() {
		return getYear() + "-" + getMonthOfYear() + "-" + getDayOfMonth();
	}
}
