package de.xam.service;

import org.xydra.base.IHasXId;

import de.xam.cmodel.service.ServiceState;

/**
 * A runtime service can be turned on or turned off.
 *
 * @author xamde
 */
public interface IService extends IHasXId {

	/**
	 * Instruct service to stop processing.
	 *
	 * Stopping might take a while. You can query via {@link #getServiceState()}
	 * and {@link ServiceState#isInactive()} for when it is really stopped.
	 */
	void stop();

	/**
	 * Start service, begin processing.
	 *
	 * Starting might take a while. You can query via {@link #getServiceState()}
	 * and {@link ServiceState#isRunning()} for when it is really running.
	 */
	void start();

	/**
	 * @return the current state this service is currently in
	 */
	ServiceState getServiceState();

	/**
	 * Note: For technical ids, use {@link #getId()}
	 *
	 * @return a human-readable display label.
	 */
	String getLabel();

}
