package de.xam.textsearch.query;

public abstract class AbstractQuery<V> implements IQuery<V> {

	private int maxResults;

	protected AbstractQuery() {
		/** default: unlimited */
		this.maxResults = Integer.MAX_VALUE;
	}

	@Override
	public AbstractQuery<V> setMaxResults(final int maxResults) {
		this.maxResults = maxResults;
		return this;
	}

	public int getMaxResults() {
		return this.maxResults;
	}

	public boolean isLimited() {
		return getMaxResults() < Integer.MAX_VALUE;
	}

}
