package de.xam.textsearch.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.ClosableIteratorAdapter;
import org.xydra.index.iterator.Iterators;

import com.google.gwt.thirdparty.guava.common.base.Joiner;

public class AndQuery<V> extends AbstractCombinedQuery<V> implements IQuery<V> {

	public static <V> AndQuery<V> create(final IQuery<V> subQuery) {
		final AndQuery<V> andQuery = new AndQuery<V>();
		return andQuery.and(subQuery);
	}

	public static <V> AndQuery<V> create() {
		final AndQuery<V> andQuery = new AndQuery<V>();
		return andQuery;
	}

	public AndQuery<V> and(final IQuery<V> subQuery) {
		add(subQuery);
		return this;
	}

	@Override
	public String toString() {
		final StringBuilder b = new StringBuilder();
		b.append("(");
		Joiner.on(" AND ").appendTo(b, super.queries);
		b.append(")");
		return b.toString();
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public ClosableIterator<V> execute() {
		switch (this.queries.size()) {
		case 0:
			return (ClosableIterator<V>) Iterators.none();
		case 1:
			return this.queries.get(0).execute();
		default:
			// IMPROVE find more efficient way
			final Set<V> intersection = intersect(this.queries);
			return new ClosableIteratorAdapter(intersection.iterator());
		}
	}

	@Override
	public Set<V> executeToSet() {
		switch (this.queries.size()) {
		case 0:
			return Collections.emptySet();
		case 1:
			return this.queries.get(0).executeToSet();
		default:
			final Set<V> intersection = intersect(this.queries);
			return intersection;
		}
	}

	private Set<V> intersect(final List<IQuery<V>> queries) {
		// probe first k sets to find a non-empty one
		int k = 0;
		Set<V> firstSet = null;
		while (firstSet == null && k < this.queries.size()) {
			final IQuery<V> firstQuery = this.queries.get(k);
			firstSet = firstQuery.executeToSet();
			k++;
		}
		if (k == this.queries.size()) {
			return Collections.emptySet();
		}
		// found a non-empty set
		assert firstSet != null;
		final Set<V> result = new HashSet<V>(firstSet.size());
		result.addAll(firstSet);
		// gradually shrink result set
		for (int i = k; i < this.queries.size(); i++) {
			final Set<V> ithSet = this.queries.get(i).executeToSet();
			if (ithSet != null) {
				result.retainAll(ithSet);
			}
		}
		return result;
	}

}
