package de.xam.textsearch.query;

import java.util.Set;

import org.xydra.index.iterator.ClosableIterator;

/**
 * A generic query can be executed. Could be a text query or any other kind of
 * query.
 *
 * @author xamde
 *
 * @param <V>
 */
public interface IQuery<V> {

	/**
	 * @return @NeverNull a set of results, ignores any max result limits
	 */
	Set<V> executeToSet();

	/**
	 * @return an iterator of distinct, matching ids; some kind of order might
	 *         be present ;-)
	 */
	ClosableIterator<V> execute();

	/**
	 * @param maxResults
	 * @return itself for a fluent API
	 */
	IQuery<V> setMaxResults(int maxResults);

}
