package de.xam.triplerules;


public interface ITriplePattern<K, L, M> {

	/**
	 * @return
	 */
	IVariable<K> s();

	/**
	 * @return
	 */
	IVariable<L> p();

	/**
	 * @return
	 */
	IVariable<M> o();

	/**
	 * Translate ids to names
	 *
	 * @param rule
	 */
	void compile(ITripleRule<K, L, M> rule);

	/**
	 * Helps debugging
	 *
	 * @param binding
	 * @return pattern with none/some/all variables bound
	 */
	String toString(IRuleConditionBinding<K, L, M> binding);

	/**
	 * @param binding
	 * @return true iff this pattern in completely bound by the binding, i.e.
	 *         when all variables in the pattern are set to concrete values in
	 *         the binding
	 */
	boolean isBound(IRuleConditionBinding<K, L, M> binding);

}
