package de.xam.tupleinf;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.xydra.index.IEntrySet;
import org.xydra.index.query.Constraint;

import com.google.gwt.thirdparty.guava.common.collect.Iterators;

/**
 * Reads a+b, writes only b.
 *
 * @author xamde
 *
 * @param <E>
 */
public class CombinedEntrySet<E> implements IEntrySet<E> {

	private static final long serialVersionUID = 1L;

	public static <E> IEntrySet<E> combine(final IEntrySet<E> a, final IEntrySet<E> b) {
		if (a == b) {
			return a;
		}
		return new CombinedEntrySet<E>(a, b);
	}

	@Override
	public void clear() {
		this.b.clear();
	}

	@Override
	public boolean isEmpty() {
		return this.a.isEmpty() && this.b.isEmpty();
	}

	@Override
	public Iterator<E> iterator() {
		return Iterators.concat(this.a.iterator(), this.b.iterator());
	}

	@Override
	public boolean deIndex(final E entry) {
		if (this.a.contains(entry)) {
			return false;
		}
		return this.b.deIndex(entry);
	}

	@Override
	public boolean index(final E entry) {
		if (this.a.contains(entry)) {
			return false;
		}
		return this.a.index(entry);
	}

	@Override
	public org.xydra.index.IEntrySet.IEntrySetDiff<E> computeDiff(final IEntrySet<E> other) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean contains(final E entry) {
		return this.a.contains(entry) || this.b.contains(entry);
	}

	@Override
	public Iterator<E> constraintIterator(final Constraint<E> entryConstraint) {
		return Iterators.concat(this.a.constraintIterator(entryConstraint),
				this.b.constraintIterator(entryConstraint));
	}

	@Override
	public int size() {
		return this.a.size() + this.b.size();
	}

	// slow
	@Override
	public Set<E> toSet() {
		final HashSet<E> set = new HashSet<E>();
		set.addAll(this.a.toSet());
		set.addAll(this.b.toSet());
		return set;
	}

	public CombinedEntrySet(final IEntrySet<E> a, final IEntrySet<E> b) {
		super();
		this.a = a;
		this.b = b;
	}

	private final IEntrySet<E> a;

	private final IEntrySet<E> b;

	@Override
	public String toString() {
		final StringBuilder b = new StringBuilder();
		b.append("{");
		final Iterator<E> it = toSet().iterator();
		while (it.hasNext()) {
			final E e = it.next();
			b.append(e.toString());
			if(it.hasNext()) {
				b.append(", ");
			}
		}
		b.append("}");
		return b.toString();
	}
}
